/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.github.L_Ender.cataclysm.init.ModSounds;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ArmorEmergencyModifier
extends Modifier
implements OnAttackedModifierHook,
ProtectionModifierHook,
InventoryTickModifierHook,
AttributesModifierHook,
DamageBlockModifierHook {
    private static final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "emergency");

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity livingEntity;
        ModDataNBT persistentData = tool.getPersistentData();
        if (amount > 0.0f && (livingEntity = context.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if ((double)RANDOM.nextFloat() <= Math.sqrt(amount) / 10.0 && !persistentData.contains(KEY, 3) && !player.m_36335_().m_41519_(tool.getItem())) {
                persistentData.putInt(KEY, 3);
                player.m_5496_((SoundEvent)ModSounds.HARBINGER_CHARGE.get(), 1.0f, 0.5f);
            }
        }
    }

    public float getProtectionModifier(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull EquipmentContext context, @Nonnull EquipmentSlot slotType, DamageSource source, float modifierValue) {
        ModDataNBT persistentData;
        if (!source.m_19378_() && (persistentData = tool.getPersistentData()).contains(KEY, 3)) {
            return modifierValue * (float)(1 + modifier.getLevel());
        }
        return modifierValue;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.PROTECTION, ModifierHooks.ON_ATTACKED, ModifierHooks.INVENTORY_TICK, ModifierHooks.DAMAGE_BLOCK});
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY, 3) && holder.f_19797_ % 20 == 0 && holder instanceof Player) {
            Player player = (Player)holder;
            if (persistentData.getInt(KEY) > 0) {
                persistentData.putInt(KEY, persistentData.getInt(KEY) - 1);
            } else {
                persistentData.remove(KEY);
                player.m_36335_().m_41524_(tool.getItem(), 20);
            }
        }
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        ModDataNBT persistentData;
        if (this.isArmor(slot) && (persistentData = tool.getPersistentData()).contains(KEY, 3)) {
            consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("36893a5c-6fdc-42f3-867f-b2f8ba5a7cb7"), Attributes.f_22279_.m_22087_(), (double)(0.2f * (float)modifier.getLevel()), AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public boolean isDamageBlocked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY, 3)) {
            return source.m_19360_();
        }
        return false;
    }
}

